<?php

$portfolioPage = new HudsonEdgeAdminPage(
	"9",
	esc_html__( "Portfolio", 'hudson' ),
	"fa fa-camera-retro"
);
$hudson_edge_framework->edgtOptions->addAdminPage(
	"portfolioPage",
	$portfolioPage
);

//Portfolio List

$panel1 = new HudsonEdgePanel(
	esc_html__( "Portfolio List", 'hudson' ),
	"porfolio_list"
);
$portfolioPage->addChild(
	"panel1",
	$panel1
);

$portfolio_edgt_like = new HudsonEdgeField(
	"onoff",
	"portfolio_edgt_like",
	"on",
	esc_html__( "Likes", 'hudson' ),
	esc_html__( 'Enabling this option will turn on "Likes"', 'hudson' )
);
$panel1->addChild(
	"portfolio_edgt_like",
	$portfolio_edgt_like
);

$portfolio_disable_text_box = new HudsonEdgeField(
	"yesno",
	"portfolio_disable_text_box",
	"yes",
	esc_html__( "Disable Boxed Style Project Description", 'hudson' ),
	esc_html__( "Disabling boxed styled project description", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "#edgtf_enable_portfolio_list_box_container",
		"dependence_show_on_yes" => ""
	)
);
$panel1->addChild(
	"portfolio_disable_text_box",
	$portfolio_disable_text_box
);

$enable_portfolio_list_box_container = new HudsonEdgeContainer(
	"enable_portfolio_list_box_container",
	"portfolio_disable_text_box",
	"yes"
);
$panel1->addChild(
	"enable_portfolio_list_box_container",
	$enable_portfolio_list_box_container
);

$portfolio_list_box_background_color = new HudsonEdgeField(
	"color",
	"portfolio_list_box_background_color",
	"",
	esc_html__( "Portfolio Box Background Color", 'hudson' ),
	esc_html__( "Default color is #ffffff", 'hudson' )
);
$enable_portfolio_list_box_container->addChild(
	"portfolio_list_box_background_color",
	$portfolio_list_box_background_color
);

$group1 = new HudsonEdgeGroup(
	esc_html__( "Image Hover Overlay Color", 'hudson' ),
	esc_html__( "Define icons styles on project hover. Default hover color is #279eff.", 'hudson' )
);
$panel1->addChild(
	"group1",
	$group1
);

$row1 = new HudsonEdgeRow();
$group1->addChild(
	"row1",
	$row1
);

$portfolio_shader_color = new HudsonEdgeField(
	"colorsimple",
	"portfolio_shader_color",
	"",
	esc_html__( "Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"portfolio_shader_color",
	$portfolio_shader_color
);

$portfolio_shader_transparency = new HudsonEdgeField(
	"textsimple",
	"portfolio_shader_transparency",
	"",
	esc_html__( "Transparency (0=full - 1=opaque)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$row1->addChild(
	"portfolio_shader_transparency",
	$portfolio_shader_transparency
);

$group25 = new HudsonEdgeGroup(
	esc_html__( "Load More Button Background", 'hudson' ),
	esc_html__( "Define load more pattern background", 'hudson' )
);
$panel1->addChild(
	"group25",
	$group25
);

$row2 = new HudsonEdgeRow();
$group25->addChild(
	"row2",
	$row2
);

$portfolio_list_button_background_pattern_image = new HudsonEdgeField(
	"imagesimple",
	"portfolio_list_button_background_pattern_image",
	"",
	esc_html__( "Pattern image", 'hudson' ),
	""
);
$row2->addChild(
	"portfolio_list_button_background_pattern_image",
	$portfolio_list_button_background_pattern_image
);

// Portfolio List TEXT STYLES

$title_text_styles = new HudsonEdgeTitle(
	"title_text_styles",
	esc_html__( "Title Text Styles", 'hudson' )
);
$panel1->addChild(
	"title_text_styles",
	$title_text_styles
);

$group7 = new HudsonEdgeGroup(
	esc_html__( "Title Style for Standard and Pinterest Lists", 'hudson' ),
	esc_html__( "Define title styles for standard and pinterest portfolio lists.", 'hudson' )
);
$panel1->addChild(
	"group7",
	$group7
);

$row1 = new HudsonEdgeRow();
$group7->addChild(
	"row1",
	$row1
);
$portfolio_title_standard_list_color = new HudsonEdgeField(
	"colorsimple",
	"portfolio_title_standard_list_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"portfolio_title_standard_list_color",
	$portfolio_title_standard_list_color
);
$portfolio_title_standard_list_hover_color = new HudsonEdgeField(
	"colorsimple",
	"portfolio_title_standard_list_hover_color",
	"",
	esc_html__( "Text Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"portfolio_title_standard_list_hover_color",
	$portfolio_title_standard_list_hover_color
);
$portfolio_title_standard_list_font_size = new HudsonEdgeField(
	"textsimple",
	"portfolio_title_standard_list_font_size",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"portfolio_title_standard_list_font_size",
	$portfolio_title_standard_list_font_size
);
$portfolio_title_standard_list_line_height = new HudsonEdgeField(
	"textsimple",
	"portfolio_title_standard_list_line_height",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"portfolio_title_standard_list_line_height",
	$portfolio_title_standard_list_line_height
);

$row2 = new HudsonEdgeRow( true );
$group7->addChild(
	"row2",
	$row2
);
$portfolio_title_standard_list_text_transform = new HudsonEdgeField(
	"selectblanksimple",
	"portfolio_title_standard_list_text_transform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row2->addChild(
	"portfolio_title_standard_list_text_transform",
	$portfolio_title_standard_list_text_transform
);
$portfolio_title_standard_list_font_family = new HudsonEdgeField(
	"fontsimple",
	"portfolio_title_standard_list_font_family",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"portfolio_title_standard_list_font_family",
	$portfolio_title_standard_list_font_family
);
$portfolio_title_standard_list_font_style = new HudsonEdgeField(
	"selectblanksimple",
	"portfolio_title_standard_list_font_style",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row2->addChild(
	"portfolio_title_standard_list_font_style",
	$portfolio_title_standard_list_font_style
);
$portfolio_title_standard_list_font_weight = new HudsonEdgeField(
	"selectblanksimple",
	"portfolio_title_standard_list_font_weight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row2->addChild(
	"portfolio_title_standard_list_font_weight",
	$portfolio_title_standard_list_font_weight
);

$row3 = new HudsonEdgeRow( true );
$group7->addChild(
	"row3",
	$row3
);
$portfolio_title_standard_list_letter_spacing = new HudsonEdgeField(
	"textsimple",
	"portfolio_title_standard_list_letter_spacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row3->addChild(
	"portfolio_title_standard_list_letter_spacing",
	$portfolio_title_standard_list_letter_spacing
);

$group9 = new HudsonEdgeGroup(
	esc_html__( "Title Style for Text on Hover Image and Text before Hover Lists", 'hudson' ),
	esc_html__( "Define title styles for text on hover image and text before hover portfolio lists.", 'hudson' )
);
$panel1->addChild(
	"group9",
	$group9
);

$row1 = new HudsonEdgeRow();
$group9->addChild(
	"row1",
	$row1
);
$portfolio_title_hover_box_list_color = new HudsonEdgeField(
	"colorsimple",
	"portfolio_title_hover_box_list_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"portfolio_title_hover_box_list_color",
	$portfolio_title_hover_box_list_color
);
$portfolio_title_hover_box_list_hover_color = new HudsonEdgeField(
	"colorsimple",
	"portfolio_title_hover_box_list_hover_color",
	"",
	esc_html__( "Text Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"portfolio_title_hover_box_list_hover_color",
	$portfolio_title_hover_box_list_hover_color
);
$portfolio_title_hover_box_list_font_size = new HudsonEdgeField(
	"textsimple",
	"portfolio_title_hover_box_list_font_size",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"portfolio_title_hover_box_list_font_size",
	$portfolio_title_hover_box_list_font_size
);
$portfolio_title_hover_box_list_line_height = new HudsonEdgeField(
	"textsimple",
	"portfolio_title_hover_box_list_line_height",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"portfolio_title_hover_box_list_line_height",
	$portfolio_title_hover_box_list_line_height
);

$row2 = new HudsonEdgeRow( true );
$group9->addChild(
	"row2",
	$row2
);
$portfolio_title_hover_box_list_font_family = new HudsonEdgeField(
	"fontsimple",
	"portfolio_title_hover_box_list_font_family",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"portfolio_title_hover_box_list_font_family",
	$portfolio_title_hover_box_list_font_family
);
$portfolio_title_hover_box_list_text_transform = new HudsonEdgeField(
	"selectblanksimple",
	"portfolio_title_hover_box_list_text_transform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row2->addChild(
	"portfolio_title_hover_box_list_text_transform",
	$portfolio_title_hover_box_list_text_transform
);
$portfolio_title_hover_box_list_font_style = new HudsonEdgeField(
	"selectblanksimple",
	"portfolio_title_hover_box_list_font_style",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row2->addChild(
	"portfolio_title_hover_box_list_font_style",
	$portfolio_title_hover_box_list_font_style
);
$portfolio_title_hover_box_list_font_weight = new HudsonEdgeField(
	"selectblanksimple",
	"portfolio_title_hover_box_list_font_weight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row2->addChild(
	"portfolio_title_hover_box_list_font_weight",
	$portfolio_title_hover_box_list_font_weight
);

$row3 = new HudsonEdgeRow( true );
$group9->addChild(
	"row3",
	$row3
);
$portfolio_title_hover_box_list_letter_spacing = new HudsonEdgeField(
	"textsimple",
	"portfolio_title_hover_box_list_letter_spacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row3->addChild(
	"portfolio_title_hover_box_list_letter_spacing",
	$portfolio_title_hover_box_list_letter_spacing
);

$group11 = new HudsonEdgeGroup(
	esc_html__( "Title Style for Portfolio Slider and Masonry Lists", 'hudson' ),
	esc_html__( "Define title styles for slider and masonry portfolio lists.", 'hudson' )
);
$panel1->addChild(
	"group11",
	$group11
);

$row1 = new HudsonEdgeRow();
$group11->addChild(
	"row1",
	$row1
);
$portfolio_title_list_color = new HudsonEdgeField(
	"colorsimple",
	"portfolio_title_list_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"portfolio_title_list_color",
	$portfolio_title_list_color
);
$portfolio_title_list_hover_color = new HudsonEdgeField(
	"colorsimple",
	"portfolio_title_list_hover_color",
	"",
	esc_html__( "Text Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"portfolio_title_list_hover_color",
	$portfolio_title_list_hover_color
);
$portfolio_title_list_font_size = new HudsonEdgeField(
	"textsimple",
	"portfolio_title_list_font_size",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"portfolio_title_list_font_size",
	$portfolio_title_list_font_size
);
$portfolio_title_list_line_height = new HudsonEdgeField(
	"textsimple",
	"portfolio_title_list_line_height",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"portfolio_title_list_line_height",
	$portfolio_title_list_line_height
);

$row2 = new HudsonEdgeRow( true );
$group11->addChild(
	"row2",
	$row2
);
$portfolio_title_list_text_transform = new HudsonEdgeField(
	"selectblanksimple",
	"portfolio_title_list_text_transform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row2->addChild(
	"portfolio_title_list_text_transform",
	$portfolio_title_list_text_transform
);
$portfolio_title_list_font_family = new HudsonEdgeField(
	"fontsimple",
	"portfolio_title_list_font_family",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"portfolio_title_list_font_family",
	$portfolio_title_list_font_family
);
$portfolio_title_list_font_style = new HudsonEdgeField(
	"selectblanksimple",
	"portfolio_title_list_font_style",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row2->addChild(
	"portfolio_title_list_font_style",
	$portfolio_title_list_font_style
);
$portfolio_title_list_font_weight = new HudsonEdgeField(
	"selectblanksimple",
	"portfolio_title_list_font_weight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row2->addChild(
	"portfolio_title_list_font_weight",
	$portfolio_title_list_font_weight
);

$row3 = new HudsonEdgeRow( true );
$group11->addChild(
	"row3",
	$row3
);
$portfolio_title_list_letter_spacing = new HudsonEdgeField(
	"textsimple",
	"portfolio_title_list_letter_spacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row3->addChild(
	"portfolio_title_list_letter_spacing",
	$portfolio_title_list_letter_spacing
);

$category_text_styles = new HudsonEdgeTitle(
	"category_text_styles",
	esc_html__( "Category Text Styles", 'hudson' )
);
$panel1->addChild(
	"category_text_styles",
	$category_text_styles
);

$group8 = new HudsonEdgeGroup(
	esc_html__( "Category Style for Standard and Pinterest Lists", 'hudson' ),
	esc_html__( "Define category styles for standard and pinterest portfolio lists.", 'hudson' )
);
$panel1->addChild(
	"group8",
	$group8
);

$row1 = new HudsonEdgeRow();
$group8->addChild(
	"row1",
	$row1
);
$portfolio_category_standard_list_color = new HudsonEdgeField(
	"colorsimple",
	"portfolio_category_standard_list_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"portfolio_category_standard_list_color",
	$portfolio_category_standard_list_color
);
$portfolio_category_standard_list_font_size = new HudsonEdgeField(
	"textsimple",
	"portfolio_category_standard_list_font_size",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"portfolio_category_standard_list_font_size",
	$portfolio_category_standard_list_font_size
);
$portfolio_category_standard_list_line_height = new HudsonEdgeField(
	"textsimple",
	"portfolio_category_standard_list_line_height",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"portfolio_category_standard_list_line_height",
	$portfolio_category_standard_list_line_height
);
$portfolio_category_standard_list_text_transform = new HudsonEdgeField(
	"selectblanksimple",
	"portfolio_category_standard_list_text_transform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row1->addChild(
	"portfolio_category_standard_list_text_transform",
	$portfolio_category_standard_list_text_transform
);

$row2 = new HudsonEdgeRow( true );
$group8->addChild(
	"row2",
	$row2
);
$portfolio_category_standard_list_font_family = new HudsonEdgeField(
	"fontsimple",
	"portfolio_category_standard_list_font_family",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"portfolio_category_standard_list_font_family",
	$portfolio_category_standard_list_font_family
);
$portfolio_category_standard_list_font_style = new HudsonEdgeField(
	"selectblanksimple",
	"portfolio_category_standard_list_font_style",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row2->addChild(
	"portfolio_category_standard_list_font_style",
	$portfolio_category_standard_list_font_style
);
$portfolio_category_standard_list_font_weight = new HudsonEdgeField(
	"selectblanksimple",
	"portfolio_category_standard_list_font_weight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row2->addChild(
	"portfolio_category_standard_list_font_weight",
	$portfolio_category_standard_list_font_weight
);
$portfolio_category_standard_list_letter_spacing = new HudsonEdgeField(
	"textsimple",
	"portfolio_category_standard_list_letter_spacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"portfolio_category_standard_list_letter_spacing",
	$portfolio_category_standard_list_letter_spacing
);

$group10 = new HudsonEdgeGroup(
	esc_html__( "Category Style for Text on Hover Image and Text before Hover Lists", 'hudson' ),
	esc_html__( "Define category styles for standard and pinterest portfolio lists.", 'hudson' )
);
$panel1->addChild(
	"group10",
	$group10
);

$row1 = new HudsonEdgeRow();
$group10->addChild(
	"row1",
	$row1
);
$portfolio_category_hover_box_list_color = new HudsonEdgeField(
	"colorsimple",
	"portfolio_category_hover_box_list_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"portfolio_category_hover_box_list_color",
	$portfolio_category_hover_box_list_color
);
$portfolio_category_hover_box_list_font_size = new HudsonEdgeField(
	"textsimple",
	"portfolio_category_hover_box_list_font_size",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"portfolio_category_hover_box_list_font_size",
	$portfolio_category_hover_box_list_font_size
);
$portfolio_category_hover_box_list_line_height = new HudsonEdgeField(
	"textsimple",
	"portfolio_category_hover_box_list_line_height",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"portfolio_category_hover_box_list_line_height",
	$portfolio_category_hover_box_list_line_height
);
$portfolio_category_hover_box_list_text_transform = new HudsonEdgeField(
	"selectblanksimple",
	"portfolio_category_hover_box_list_text_transform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row1->addChild(
	"portfolio_category_hover_box_list_text_transform",
	$portfolio_category_hover_box_list_text_transform
);

$row2 = new HudsonEdgeRow( true );
$group10->addChild(
	"row2",
	$row2
);
$portfolio_category_hover_box_list_font_family = new HudsonEdgeField(
	"fontsimple",
	"portfolio_category_hover_box_list_font_family",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"portfolio_category_hover_box_list_font_family",
	$portfolio_category_hover_box_list_font_family
);
$portfolio_category_hover_box_list_font_style = new HudsonEdgeField(
	"selectblanksimple",
	"portfolio_category_hover_box_list_font_style",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row2->addChild(
	"portfolio_category_hover_box_list_font_style",
	$portfolio_category_hover_box_list_font_style
);
$portfolio_category_hover_box_list_font_weight = new HudsonEdgeField(
	"selectblanksimple",
	"portfolio_category_hover_box_list_font_weight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row2->addChild(
	"portfolio_category_hover_box_list_font_weight",
	$portfolio_category_hover_box_list_font_weight
);
$portfolio_category_hover_box_list_letter_spacing = new HudsonEdgeField(
	"textsimple",
	"portfolio_category_hover_box_list_letter_spacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"portfolio_category_hover_box_list_letter_spacing",
	$portfolio_category_hover_box_list_letter_spacing
);

$group12 = new HudsonEdgeGroup(
	esc_html__( "Category Style for Portfolio Slider and Masonry Lists", 'hudson' ),
	esc_html__( "Define category styles for slider and masonry portfolio lists.", 'hudson' )
);
$panel1->addChild(
	"group12",
	$group12
);

$row1 = new HudsonEdgeRow();
$group12->addChild(
	"row1",
	$row1
);
$portfolio_category_list_color = new HudsonEdgeField(
	"colorsimple",
	"portfolio_category_list_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"portfolio_category_list_color",
	$portfolio_category_list_color
);
$portfolio_category_list_font_size = new HudsonEdgeField(
	"textsimple",
	"portfolio_category_list_font_size",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"portfolio_category_list_font_size",
	$portfolio_category_list_font_size
);
$portfolio_category_list_line_height = new HudsonEdgeField(
	"textsimple",
	"portfolio_category_list_line_height",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"portfolio_category_list_line_height",
	$portfolio_category_list_line_height
);
$portfolio_category_list_text_transform = new HudsonEdgeField(
	"selectblanksimple",
	"portfolio_category_list_text_transform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row1->addChild(
	"portfolio_category_list_text_transform",
	$portfolio_category_list_text_transform
);

$row2 = new HudsonEdgeRow( true );
$group12->addChild(
	"row2",
	$row2
);
$portfolio_category_list_font_family = new HudsonEdgeField(
	"fontsimple",
	"portfolio_category_list_font_family",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"portfolio_category_list_font_family",
	$portfolio_category_list_font_family
);
$portfolio_category_list_font_style = new HudsonEdgeField(
	"selectblanksimple",
	"portfolio_category_list_font_style",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row2->addChild(
	"portfolio_category_list_font_style",
	$portfolio_category_list_font_style
);
$portfolio_category_list_font_weight = new HudsonEdgeField(
	"selectblanksimple",
	"portfolio_category_list_font_weight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row2->addChild(
	"portfolio_category_list_font_weight",
	$portfolio_category_list_font_weight
);
$portfolio_category_list_letter_spacing = new HudsonEdgeField(
	"textsimple",
	"portfolio_category_list_letter_spacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"portfolio_category_list_letter_spacing",
	$portfolio_category_list_letter_spacing
);

// Portfolio Filter
$portfolio_filter = new HudsonEdgeTitle(
	"portfolio_filter",
	esc_html__( "Category Filter", 'hudson' )
);
$panel1->addChild(
	"portfolio_filter",
	$portfolio_filter
);

$portfolio_list_filter_background_color = new HudsonEdgeField(
	"color",
	"portfolio_list_filter_background_color",
	"",
	esc_html__( "Background Color", 'hudson' ),
	esc_html__( "Choose color for background of filter area", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$panel1->addChild(
	"portfolio_list_filter_background_color",
	$portfolio_list_filter_background_color
);

$portfolio_list_filter_height = new HudsonEdgeField(
	"text",
	"portfolio_list_filter_height",
	"",
	esc_html__( "Height (px)", 'hudson' ),
	esc_html__( "Enter height for filter area", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$panel1->addChild(
	"portfolio_list_filter_height",
	$portfolio_list_filter_height
);

$portfolio_filter_margin_bottom = new HudsonEdgeField(
	"text",
	"portfolio_filter_margin_bottom",
	"",
	esc_html__( "Bottom Margin (px)", 'hudson' ),
	esc_html__( "Enter bottom margin for filter area. Default value is 36", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$panel1->addChild(
	"portfolio_filter_margin_bottom",
	$portfolio_filter_margin_bottom
);

$group2 = new HudsonEdgeGroup(
	esc_html__( "Title", 'hudson' ),
	esc_html__( "Define text styles for filter title", 'hudson' )
);
$panel1->addChild(
	"group2",
	$group2
);

$row1 = new HudsonEdgeRow();
$group2->addChild(
	"row1",
	$row1
);
$portfolio_filter_title_color = new HudsonEdgeField(
	"colorsimple",
	"portfolio_filter_title_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"portfolio_filter_title_color",
	$portfolio_filter_title_color
);
$portfolio_filter_title_font_size = new HudsonEdgeField(
	"textsimple",
	"portfolio_filter_title_font_size",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"portfolio_filter_title_font_size",
	$portfolio_filter_title_font_size
);
$portfolio_filter_title_line_height = new HudsonEdgeField(
	"textsimple",
	"portfolio_filter_title_line_height",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"portfolio_filter_title_line_height",
	$portfolio_filter_title_line_height
);
$portfolio_filter_title_text_transform = new HudsonEdgeField(
	"selectblanksimple",
	"portfolio_filter_title_text_transform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row1->addChild(
	"portfolio_filter_title_text_transform",
	$portfolio_filter_title_text_transform
);

$row2 = new HudsonEdgeRow( true );
$group2->addChild(
	"row2",
	$row2
);
$portfolio_filter_title_font_family = new HudsonEdgeField(
	"fontsimple",
	"portfolio_filter_title_font_family",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"portfolio_filter_title_font_family",
	$portfolio_filter_title_font_family
);
$portfolio_filter_title_font_style = new HudsonEdgeField(
	"selectblanksimple",
	"portfolio_filter_title_font_style",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row2->addChild(
	"portfolio_filter_title_font_style",
	$portfolio_filter_title_font_style
);
$portfolio_filter_title_font_weight = new HudsonEdgeField(
	"selectblanksimple",
	"portfolio_filter_title_font_weight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row2->addChild(
	"portfolio_filter_title_font_weight",
	$portfolio_filter_title_font_weight
);
$portfolio_filter_title_letter_spacing = new HudsonEdgeField(
	"textsimple",
	"portfolio_filter_title_letter_spacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"portfolio_filter_title_letter_spacing",
	$portfolio_filter_title_letter_spacing
);

$group3 = new HudsonEdgeGroup(
	esc_html__( "Categories", 'hudson' ),
	esc_html__( "Define text styles for filter categories", 'hudson' )
);
$panel1->addChild(
	"group3",
	$group3
);

$row1 = new HudsonEdgeRow();
$group3->addChild(
	"row1",
	$row1
);
$portfolio_filter_color = new HudsonEdgeField(
	"colorsimple",
	"portfolio_filter_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"portfolio_filter_color",
	$portfolio_filter_color
);
$portfolio_filter_hovercolor = new HudsonEdgeField(
	"colorsimple",
	"portfolio_filter_hovercolor",
	"",
	esc_html__( "Hover/Active Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"portfolio_filter_hovercolor",
	$portfolio_filter_hovercolor
);
$portfolio_filter_font_size = new HudsonEdgeField(
	"textsimple",
	"portfolio_filter_font_size",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"portfolio_filter_font_size",
	$portfolio_filter_font_size
);
$portfolio_filter_line_height = new HudsonEdgeField(
	"textsimple",
	"portfolio_filter_line_height",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"portfolio_filter_line_height",
	$portfolio_filter_line_height
);

$row2 = new HudsonEdgeRow( true );
$group3->addChild(
	"row2",
	$row2
);
$portfolio_filter_font_family = new HudsonEdgeField(
	"fontsimple",
	"portfolio_filter_font_family",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"portfolio_filter_font_family",
	$portfolio_filter_font_family
);
$portfolio_filter_font_style = new HudsonEdgeField(
	"selectblanksimple",
	"portfolio_filter_font_style",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row2->addChild(
	"portfolio_filter_font_style",
	$portfolio_filter_font_style
);
$portfolio_filter_font_weight = new HudsonEdgeField(
	"selectblanksimple",
	"portfolio_filter_font_weight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row2->addChild(
	"portfolio_filter_font_weight",
	$portfolio_filter_font_weight
);
$portfolio_filter_text_transform = new HudsonEdgeField(
	"selectblanksimple",
	"portfolio_filter_text_transform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row2->addChild(
	"portfolio_filter_text_transform",
	$portfolio_filter_text_transform
);

$row3 = new HudsonEdgeRow( true );
$group3->addChild(
	"row3",
	$row3
);
$portfolio_filter_letter_spacing = new HudsonEdgeField(
	"textsimple",
	"portfolio_filter_letter_spacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row3->addChild(
	"portfolio_filter_letter_spacing",
	$portfolio_filter_letter_spacing
);

$portfolio_filter_disable_separator = new HudsonEdgeField(
	"yesno",
	"portfolio_filter_disable_separator",
	"yes",
	esc_html__( "Disable Separator Between Categories", 'hudson' ),
	esc_html__( "Disabling this option will remove separator between filter categories.", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "#edgtf_portfolio_filter_separator_container",
		"dependence_show_on_yes" => "",
	)
);
$panel1->addChild(
	"portfolio_filter_disable_separator",
	$portfolio_filter_disable_separator
);

$portfolio_filter_separator_container = new HudsonEdgeContainer(
	"portfolio_filter_separator_container",
	"portfolio_filter_disable_separator",
	"yes"
);
$panel1->addChild(
	"portfolio_filter_separator_container",
	$portfolio_filter_separator_container
);

$portfolio_filter_separator_color = new HudsonEdgeField(
	"color",
	"portfolio_filter_separator_color",
	"",
	esc_html__( "Separator Between Categories Color", 'hudson' ),
	esc_html__( "Choose a color for separator between categories in filter", 'hudson' )
);
$portfolio_filter_separator_container->addChild(
	"portfolio_filter_separator_color",
	$portfolio_filter_separator_color
);

//ICONS STYLE
$icons_style = new HudsonEdgeTitle(
	"icons_style",
	esc_html__( "Icons", 'hudson' )
);
$panel1->addChild(
	"icons_style",
	$icons_style
);

$portfolio_list_icons_pack = new HudsonEdgeField(
	"select",
	"portfolio_list_icons_pack",
	"font-awesome",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( 'Choose font family for hover icons on portfolio', 'hudson' ),
	array(
		"font-awesome" => esc_html__( "Font Awesome", 'hudson' ),
		"font-elegant" => esc_html__( "Font Elegant", 'hudson' )
	)
);
$panel1->addChild(
	"portfolio_list_icons_pack",
	$portfolio_list_icons_pack
);

$portfolio_list_icons_size = new HudsonEdgeField(
	"text",
	"portfolio_list_icons_size",
	"",
	esc_html__( "Size (px)", 'hudson' ),
	esc_html__( "Enter size for icons in portfolio list. Default value is 16", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$panel1->addChild(
	"portfolio_list_icons_size",
	$portfolio_list_icons_size
);

$group4 = new HudsonEdgeGroup(
	esc_html__( "Color", 'hudson' ),
	esc_html__( "Choose color of the icons on project hover", 'hudson' )
);
$panel1->addChild(
	"group4",
	$group4
);

$row1 = new HudsonEdgeRow();
$group4->addChild(
	"row1",
	$row1
);
$portfolio_list_icons_color = new HudsonEdgeField(
	"colorsimple",
	"portfolio_list_icons_color",
	"",
	esc_html__( "Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"portfolio_list_icons_color",
	$portfolio_list_icons_color
);
$portfolio_list_icons_hover_color = new HudsonEdgeField(
	"colorsimple",
	"portfolio_list_icons_hover_color",
	"",
	esc_html__( "Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"portfolio_list_icons_hover_color",
	$portfolio_list_icons_hover_color
);

$group5 = new HudsonEdgeGroup(
	esc_html__( "Background Color", 'hudson' ),
	esc_html__( "Define icons background color styles on project hover", 'hudson' )
);
$panel1->addChild(
	"group5",
	$group5
);

$row1 = new HudsonEdgeRow();
$group5->addChild(
	"row1",
	$row1
);
$portfolio_list_icons_background_color = new HudsonEdgeField(
	"colorsimple",
	"portfolio_list_icons_background_color",
	"",
	esc_html__( "Background Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"portfolio_list_icons_background_color",
	$portfolio_list_icons_background_color
);
$portfolio_list_icons_background_hover_color = new HudsonEdgeField(
	"colorsimple",
	"portfolio_list_icons_background_hover_color",
	"",
	esc_html__( "Background Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"portfolio_list_icons_background_hover_color",
	$portfolio_list_icons_background_hover_color
);

$group6 = new HudsonEdgeGroup(
	esc_html__( "Border", 'hudson' ),
	esc_html__( "Define icons border styles on project hover", 'hudson' )
);
$panel1->addChild(
	"group6",
	$group6
);

$row1 = new HudsonEdgeRow( true );
$group6->addChild(
	"row1",
	$row1
);

$portfolio_list_icons_border_color = new HudsonEdgeField(
	"colorsimple",
	"portfolio_list_icons_border_color",
	"",
	esc_html__( "Border Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"portfolio_list_icons_border_color",
	$portfolio_list_icons_border_color
);
$portfolio_list_icons_border_hover_color = new HudsonEdgeField(
	"colorsimple",
	"portfolio_list_icons_border_hover_color",
	"",
	esc_html__( "Border Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"portfolio_list_icons_border_hover_color",
	$portfolio_list_icons_border_hover_color
);
$portfolio_list_icons_border_width = new HudsonEdgeField(
	"textsimple",
	"portfolio_list_icons_border_width",
	"",
	esc_html__( "Border Width (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"portfolio_list_icons_border_width",
	$portfolio_list_icons_border_width
);
$portfolio_list_icons_border_radius = new HudsonEdgeField(
	"textsimple",
	"portfolio_list_icons_border_radius",
	"",
	esc_html__( "Border Radius (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"portfolio_list_icons_border_radius",
	$portfolio_list_icons_border_radius
);

$portfolio_pinterest_style = new HudsonEdgeTitle(
	"portfolio_pinterest_style",
	esc_html__( "Pinterest", 'hudson' )
);
$panel1->addChild(
	"portfolio_pinterest_style",
	$portfolio_pinterest_style
);

$group24 = new HudsonEdgeGroup(
	esc_html__( "Pinterest Padding", 'hudson' ),
	esc_html__( "Define pinterest padding", 'hudson' )
);
$panel1->addChild(
	"group24",
	$group24
);

$row1 = new HudsonEdgeRow( true );
$group24->addChild(
	"row1",
	$row1
);

$pinterest_padding_left = new HudsonEdgeField(
	"textsimple",
	"pinterest_padding_left",
	"",
	esc_html__( "Padding Left (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"pinterest_padding_left",
	$pinterest_padding_left
);

$pinterest_padding_right = new HudsonEdgeField(
	"textsimple",
	"pinterest_padding_right",
	"",
	esc_html__( "Padding Right (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"pinterest_padding_right",
	$pinterest_padding_right
);

$pinterest_padding_top = new HudsonEdgeField(
	"textsimple",
	"pinterest_padding_top",
	"",
	esc_html__( "Padding Top (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"pinterest_padding_top",
	$pinterest_padding_top
);

$pinterest_padding_bottom = new HudsonEdgeField(
	"textsimple",
	"pinterest_padding_bottom",
	"",
	esc_html__( "Padding Bottom (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"pinterest_padding_bottom",
	$pinterest_padding_bottom
);

$portfolio_masonry_style = new HudsonEdgeTitle(
	"portfolio_masonry_style",
	esc_html__( "Masonry", 'hudson' )
);
$panel1->addChild(
	"portfolio_masonry_style",
	$portfolio_masonry_style
);

$portfolio_masonry_with_padding_width = new HudsonEdgeField(
	"text",
	"portfolio_masonry_with_padding_width",
	"",
	esc_html__( "Space Width (px)", 'hudson' ),
	esc_html__( "Enter space width for Masonry if space is enabled. Default value is 10", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$panel1->addChild(
	"portfolio_masonry_with_padding_width",
	$portfolio_masonry_with_padding_width
);

$thin_plus_only_style = new HudsonEdgeTitle(
	"thin_plus_only_style",
	esc_html__( "Thin Plus Only", 'hudson' )
);
$panel1->addChild(
	"thin_plus_only_style",
	$thin_plus_only_style
);

$group13 = new HudsonEdgeGroup(
	esc_html__( "Cursor", 'hudson' ),
	esc_html__( "Define styles for Cursor on Thin Plus Only hover type", 'hudson' )
);
$panel1->addChild(
	"group13",
	$group13
);

$row1 = new HudsonEdgeRow();
$group13->addChild(
	"row1",
	$row1
);
$thin_plus_only_style_color = new HudsonEdgeField(
	"colorsimple",
	"thin_plus_only_style_color",
	"",
	esc_html__( "Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"thin_plus_only_style_color",
	$thin_plus_only_style_color
);
$thin_plus_only_style_size = new HudsonEdgeField(
	"textsimple",
	"thin_plus_only_style_size",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"thin_plus_only_style_size",
	$thin_plus_only_style_size
);
$thin_plus_only_style_weight = new HudsonEdgeField(
	"selectblanksimple",
	"thin_plus_only_style_weight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row1->addChild(
	"thin_plus_only_style_weight",
	$thin_plus_only_style_weight
);

$animated_border_hover_style = new HudsonEdgeTitle(
	"animated_border_hover_style",
	esc_html__( "Animated Border", 'hudson' )
);
$panel1->addChild(
	"animated_border_hover_style",
	$animated_border_hover_style
);

$group23 = new HudsonEdgeGroup(
	esc_html__( "Border Hover", 'hudson' ),
	esc_html__( "Define styles for border on Animated Border hover type", 'hudson' )
);
$panel1->addChild(
	"group23",
	$group23
);

$row1 = new HudsonEdgeRow();
$group23->addChild(
	"row1",
	$row1
);
$animated_border_hover_color = new HudsonEdgeField(
	"colorsimple",
	"animated_border_hover_color",
	"",
	esc_html__( "Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"animated_border_hover_color",
	$animated_border_hover_color
);
$animated_border_hover_width = new HudsonEdgeField(
	"textsimple",
	"animated_border_hover_width",
	"",
	esc_html__( "Width (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"animated_border_hover_width",
	$animated_border_hover_width
);

$group27 = new HudsonEdgeGroup(
	esc_html__( "Border Padding", 'hudson' ),
	esc_html__( "Define padding for border on Animated Border hover type", 'hudson' )
);
$panel1->addChild(
	"group27",
	$group27
);

$row1 = new HudsonEdgeRow();
$group27->addChild(
	"row1",
	$row1
);
$animated_border_hover_padding_top_bottom = new HudsonEdgeField(
	"textsimple",
	"animated_border_hover_padding_top_bottom",
	"",
	esc_html__( "Top - Bottom ('px' or '%')", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"animated_border_hover_padding_top_bottom",
	$animated_border_hover_padding_top_bottom
);
$animated_border_hover_padding_left_right = new HudsonEdgeField(
	"textsimple",
	"animated_border_hover_padding_left_right",
	"",
	esc_html__( "Left - Right ('px' or '%')", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"animated_border_hover_padding_left_right",
	$animated_border_hover_padding_left_right
);

$animated_border_disable_animation = new HudsonEdgeField(
	"yesno",
	"animated_border_disable_animation",
	"no",
	esc_html__( "Disable Animation", 'hudson' ),
	esc_html__( "Enabling this option will turn off border animation on hover", 'hudson' )
);
$panel1->addChild(
	"animated_border_disable_animation",
	$animated_border_disable_animation
);

$border_with_pattern_style = new HudsonEdgeTitle(
	"border_with_pattern_style",
	esc_html__( "Border With Pattern", 'hudson' )
);
$panel1->addChild(
	"border_with_pattern_style",
	$border_with_pattern_style
);

$group26 = new HudsonEdgeGroup(
	esc_html__( 'Pattern style', 'hudson' ),
	esc_html__( 'Define Pattern Image Overlay Style', 'hudson' )
);
$panel1->addChild(
	'$group26',
	$group26
);

$row1 = new HudsonEdgeRow();
$group26->addChild(
	'row1',
	$row1
);
$border_with_pattern_color = new HudsonEdgeField(
	'colorsimple',
	'border_with_pattern_color',
	'',
	esc_html__( 'Color', 'hudson' )
);
$row1->addChild(
	'border_with_pattern_color',
	$border_with_pattern_color
);
$border_with_pattern_border_pattern = new HudsonEdgeField(
	"imagesimple",
	"border_with_pattern_border_pattern",
	"",
	esc_html__( "Border Pattern", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"border_with_pattern_border_pattern",
	$border_with_pattern_border_pattern
);
$border_with_pattern_border_width = new HudsonEdgeField(
	"textsimple",
	"border_with_pattern_border_width",
	"",
	esc_html__( "Border Width (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"border_with_pattern_border_width",
	$border_with_pattern_border_width
);

//Portfolio Single Project

$panel2 = new HudsonEdgePanel(
	esc_html__( "Portfolio Single", 'hudson' ),
	"porfolio_single_project"
);
$portfolioPage->addChild(
	"panel2",
	$panel2
);

$portfolio_style = new HudsonEdgeField(
	"select",
	"portfolio_style",
	"small-images",
	esc_html__( "Portfolio Type", 'hudson' ),
	esc_html__( 'Choose a default type for Single Project pages', 'hudson' ),
	array(
		"small-images" => esc_html__( "Portfolio small images", 'hudson' ),
		"small-slider" => esc_html__( "Portfolio small slider", 'hudson' ),
		"big-images" => esc_html__( "Portfolio big images", 'hudson' ),
		"big-slider" => esc_html__( "Portfolio big slider", 'hudson' ),
		"custom" => esc_html__( "Portfolio custom", 'hudson' ),
		"full-width-custom" => esc_html__( "Portfolio full width custom", 'hudson' ),
		"gallery" => esc_html__( "Portfolio gallery", 'hudson' )
	)
);
$panel2->addChild(
	"portfolio_style",
	$portfolio_style
);

$group3 = new HudsonEdgeGroup(
	esc_html__( "Portfolio Overlay Color", 'hudson' ),
	esc_html__( "Define color and opacity for overlay color", 'hudson' )
);
$panel2->addChild(
	"group3",
	$group3
);

$row1 = new HudsonEdgeRow();
$group3->addChild(
	"row1",
	$row1
);

$portfolio_gallery_overlay_color = new HudsonEdgeField(
	"colorsimple",
	"portfolio_gallery_overlay_color",
	"",
	esc_html__( "Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"portfolio_gallery_overlay_color",
	$portfolio_gallery_overlay_color
);

$portfolio_gallery_overlay_transparency = new HudsonEdgeField(
	"textsimple",
	"portfolio_gallery_overlay_transparency",
	"",
	esc_html__( "Transparency (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"portfolio_gallery_overlay_transparency",
	$portfolio_gallery_overlay_transparency
);

$portfolio_gallery_image_hover_style = new HudsonEdgeField(
	"select",
	"portfolio_gallery_image_hover_style",
	"magnifier",
	esc_html__( "Portfolio Image Hover", 'hudson' ),
	esc_html__( 'Choose a default hover type for Single Project pages', 'hudson' ),
	array(
		"disable" => esc_html__( "None", 'hudson' ),
		"magnifier" => esc_html__( "Magnifier", 'hudson' ),
		"icon" => esc_html__( "Icon", 'hudson' ),
		"text" => esc_html__( "Image Title", 'hudson' )
	),
	array(
		"dependence" => true,
		"hide"       => array(
			"disable"   => "#edgtf_portfolio_gallery_image_hover_separator_container,#edgtf_portfolio_gallery_image_hover_icon_container",
			"magnifier" => "#edgtf_portfolio_gallery_image_hover_separator_container,#edgtf_portfolio_gallery_image_hover_icon_container",
			"icon"      => "#edgtf_portfolio_gallery_image_hover_separator_container",
			"text"      => "#edgtf_portfolio_gallery_image_hover_icon_container"
		),
		"show"       => array(
			"disable"   => "",
			"magnifier" => "",
			"icon"      => "#edgtf_portfolio_gallery_image_hover_icon_container",
			"text"      => "#edgtf_portfolio_gallery_image_hover_separator_container"
		)
	)
);
$panel2->addChild(
	"portfolio_gallery_image_hover_style",
	$portfolio_gallery_image_hover_style
);

$portfolio_gallery_image_hover_separator_container = new HudsonEdgeContainer(
	"portfolio_gallery_image_hover_separator_container",
	"portfolio_gallery_image_hover_style",
	"magnifier",
	array( "disable", "magnifier", "icon" )
);
$panel2->addChild(
	"portfolio_gallery_image_hover_separator_container",
	$portfolio_gallery_image_hover_separator_container
);

$portfolio_gallery_image_hover_separator = new HudsonEdgeField(
	"select",
	"portfolio_gallery_image_hover_separator",
	"",
	esc_html__( "Separator below image title", 'hudson' ),
	esc_html__( "This option will place separator below text", 'hudson' ),
	array(
		"yes" => esc_html__( "Yes", 'hudson' ),
		"no" => esc_html__( "No", 'hudson' )
	),
	array( "col_width" => 3 )
);
$portfolio_gallery_image_hover_separator_container->addChild(
	"portfolio_gallery_image_hover_separator",
	$portfolio_gallery_image_hover_separator
);

$portfolio_gallery_overlay_text_color = new HudsonEdgeField(
	"color",
	"portfolio_gallery_overlay_text_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "Choose a color for overlay text in Single Project pages", 'hudson' )
);
$portfolio_gallery_image_hover_separator_container->addChild(
	"portfolio_gallery_overlay_text_color",
	$portfolio_gallery_overlay_text_color
);

$portfolio_gallery_image_hover_icon_container = new HudsonEdgeContainer(
	"portfolio_gallery_image_hover_icon_container",
	"portfolio_gallery_image_hover_style",
	"magnifier",
	array( "disable", "magnifier", "text" )
);
$panel2->addChild(
	"portfolio_gallery_image_hover_icon_container",
	$portfolio_gallery_image_hover_icon_container
);

$group4 = new HudsonEdgeGroup(
	esc_html__( "Portfolio Image Hover Icon", 'hudson' ),
	esc_html__( "Define style for Portfolio Image Hover Icon", 'hudson' )
);
$portfolio_gallery_image_hover_icon_container->addChild(
	"group4",
	$group4
);

$row1 = new HudsonEdgeRow();
$group4->addChild(
	"row1",
	$row1
);

$portfolio_gallery_icon_pack = new HudsonEdgeField(
	"selectsimple",
	"portfolio_gallery_icon_pack",
	"font-awesome",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( 'This is some description', 'hudson' ),
	array(
		"font-awesome" => esc_html__( "Font Awesome", 'hudson' ),
		"font-elegant" => esc_html__( "Font Elegant", 'hudson' )
	)
);
$group4->addChild(
	"portfolio_gallery_icon_pack",
	$portfolio_gallery_icon_pack
);

$portfolio_gallery_icon_size = new HudsonEdgeField(
	"textsimple",
	"portfolio_gallery_icon_size",
	"",
	esc_html__( "Size", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$group4->addChild(
	"portfolio_gallery_icon_size",
	$portfolio_gallery_icon_size
);

$portfolio_gallery_icon_color = new HudsonEdgeField(
	"colorsimple",
	"portfolio_gallery_icon_color",
	"",
	esc_html__( "Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$group4->addChild(
	"portfolio_gallery_icon_color",
	$portfolio_gallery_icon_color
);

$group1 = new HudsonEdgeGroup(
	esc_html__( "Title Style", 'hudson' ),
	esc_html__( "Define title styles on project.", 'hudson' )
);
$panel2->addChild(
	"group1",
	$group1
);

$row1 = new HudsonEdgeRow();
$group1->addChild(
	"row1",
	$row1
);

$portfolio_title_tag = new HudsonEdgeField(
	"selectsimple",
	"portfolio_title_tag",
	"h3",
	esc_html__( "Tag element", 'hudson' ),
	esc_html__( 'This is some description', 'hudson' ),
	array(
		"h2" => esc_html__( "h2", 'hudson' ),
		"h3" => esc_html__( "h3", 'hudson' ),
		"h4" => esc_html__( "h4", 'hudson' ),
		"h5" => esc_html__( "h5", 'hudson' )
	)
);
$row1->addChild(
	"portfolio_title_tag",
	$portfolio_title_tag
);

$portfolio_title_margin_bottom = new HudsonEdgeField(
	"textsimple",
	"portfolio_title_margin_bottom",
	"",
	esc_html__( "Margin Bottom (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"portfolio_title_margin_bottom",
	$portfolio_title_margin_bottom
);

$portfolio_title_color = new HudsonEdgeField(
	"colorsimple",
	"portfolio_title_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"portfolio_title_color",
	$portfolio_title_color
);

$group2 = new HudsonEdgeGroup(
	esc_html__( "Additional Portfolio Titles", 'hudson' ),
	esc_html__( "Define additional portfolio titles styles on project.", 'hudson' )
);
$panel2->addChild(
	"group2",
	$group2
);

$row1 = new HudsonEdgeRow();
$group2->addChild(
	"row1",
	$row1
);

$portfolio_info_tag = new HudsonEdgeField(
	"selectsimple",
	"portfolio_info_tag",
	"h6",
	esc_html__( "Tag element", 'hudson' ),
	esc_html__( 'This is some description', 'hudson' ),
	array(
		"h4" => esc_html__( "h4", 'hudson' ),
		"h5" => esc_html__( "h5", 'hudson' ),
		"h6" => esc_html__( "h6", 'hudson' )
	)
);
$row1->addChild(
	"portfolio_info_tag",
	$portfolio_info_tag
);

$portfolio_info_margin_bottom = new HudsonEdgeField(
	"textsimple",
	"portfolio_info_margin_bottom",
	"",
	esc_html__( "Margin Bottom (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"portfolio_info_margin_bottom",
	$portfolio_info_margin_bottom
);

$portfolio_info_color = new HudsonEdgeField(
	"colorsimple",
	"portfolio_info_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"portfolio_info_color",
	$portfolio_info_color
);

$lightbox_single_project = new HudsonEdgeField(
	"yesno",
	"lightbox_single_project",
	"yes",
	esc_html__( "Lightbox for Images", 'hudson' ),
	esc_html__( "Enabling this option will turn on lightbox functionality for projects with images.", 'hudson' )
);
$panel2->addChild(
	"lightbox_single_project",
	$lightbox_single_project
);

$lightbox_video_single_project = new HudsonEdgeField(
	"yesno",
	"lightbox_video_single_project",
	"no",
	esc_html__( "Lightbox for Videos", 'hudson' ),
	esc_html__( "Enabling this option will turn on lightbox functionality for YouTube/Vimeo projects.", 'hudson' )
);
$panel2->addChild(
	"lightbox_video_single_project",
	$lightbox_video_single_project
);

$portfolio_hide_categories = new HudsonEdgeField(
	"yesno",
	"portfolio_hide_categories",
	"no",
	esc_html__( "Hide Categories", 'hudson' ),
	esc_html__( "Enabling this option will disable category meta description on Single Projects.", 'hudson' )
);
$panel2->addChild(
	"portfolio_hide_categories",
	$portfolio_hide_categories
);

$portfolio_hide_date = new HudsonEdgeField(
	"yesno",
	"portfolio_hide_date",
	"no",
	esc_html__( "Hide Date", 'hudson' ),
	esc_html__( "Enabling this option will disable date meta on Single Projects.", 'hudson' )
);
$panel2->addChild(
	"portfolio_hide_date",
	$portfolio_hide_date
);

$portfolio_hide_comments = new HudsonEdgeField(
	"yesno",
	"portfolio_hide_comments",
	"yes",
	esc_html__( "Hide Comments", 'hudson' ),
	esc_html__( "Enabling this option will turn off comments functionality.", 'hudson' )
);
$panel2->addChild(
	"portfolio_hide_comments",
	$portfolio_hide_comments
);

$portfolio_hide_share = new HudsonEdgeField(
	"yesno",
	"portfolio_hide_share",
	"no",
	esc_html__( "Hide Share", 'hudson' ),
	esc_html__( "Enabling this option will turn off share functionality.", 'hudson' )
);
$panel2->addChild(
	"portfolio_hide_share",
	$portfolio_hide_share
);

$portfolio_hide_like = new HudsonEdgeField(
	"yesno",
	"portfolio_hide_like",
	"no",
	esc_html__( "Hide Like", 'hudson' ),
	esc_html__( "Enabling this option will turn off like functionality.", 'hudson' )
);
$panel2->addChild(
	"portfolio_hide_like",
	$portfolio_hide_like
);

$portfolio_enable_pattern = new HudsonEdgeField(
	"yesno",
	"portfolio_enable_pattern",
	"yes",
	esc_html__( "Enable Pattern", 'hudson' ),
	esc_html__( "Enabling pattern on Like and Share holder", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_portfolio_info_pattern_holder",
	)
);
$panel2->addChild(
	"portfolio_enable_pattern",
	$portfolio_enable_pattern
);

$portfolio_info_pattern_holder = new HudsonEdgeContainer(
	"portfolio_info_pattern_holder",
	"portfolio_enable_pattern",
	"no"
);
$panel2->addChild(
	"portfolio_info_pattern_holder",
	$portfolio_info_pattern_holder
);

$portfolio_info_pattern = new HudsonEdgeField(
	"image",
	"portfolio_info_pattern",
	"",
	esc_html__( "Pattern", 'hudson' ),
	esc_html__( "Choose pattern for Like and Share holder", 'hudson' )
);
$portfolio_info_pattern_holder->addChild(
	"portfolio_info_pattern",
	$portfolio_info_pattern
);

$portfolio_text_follow = new HudsonEdgeField(
	"portfoliofollow",
	"portfolio_text_follow",
	"portfolio_single_follow",
	esc_html__( "Sticky Side Text ", 'hudson' ),
	esc_html__( "Enabling this option will make side text sticky on Single Project pages", 'hudson' )
);
$panel2->addChild(
	"portfolio_text_follow",
	$portfolio_text_follow
);

$portfolio_hide_pagination = new HudsonEdgeField(
	"yesno",
	"portfolio_hide_pagination",
	"no",
	esc_html__( "Hide Pagination", 'hudson' ),
	esc_html__( "Enabling this option will turn off portfolio pagination functionality.", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "#edgtf_portfolio_hide_pagination_container",
		"dependence_show_on_yes" => ""
	)
);
$panel2->addChild(
	"portfolio_hide_pagination",
	$portfolio_hide_pagination
);

$portfolio_hide_pagination_container = new HudsonEdgeContainer(
	"portfolio_hide_pagination_container",
	"portfolio_hide_pagination",
	"yes"
);
$panel2->addChild(
	"portfolio_hide_pagination_container",
	$portfolio_hide_pagination_container
);

$portfolio_navigation_through_same_category = new HudsonEdgeField(
	"yesno",
	"portfolio_navigation_through_same_category",
	"no",
	esc_html__( "Enable Pagination Through Same Category", 'hudson' ),
	esc_html__( "Enabling this option will make portfolio pagination sort through current category.", 'hudson' )
);
$portfolio_hide_pagination_container->addChild(
	"portfolio_navigation_through_same_category",
	$portfolio_navigation_through_same_category
);

$portfolio_navigation_border_color = new HudsonEdgeField(
	"color",
	"portfolio_navigation_border_color",
	"",
	esc_html__( "Border Top Color", 'hudson' ),
	esc_html__( "Choose border top color for navigation", 'hudson' )
);
$portfolio_hide_pagination_container->addChild(
	"portfolio_navigation_border_color",
	$portfolio_navigation_border_color
);

$portfolio_navigation_border_width = new HudsonEdgeField(
	"text",
	"portfolio_navigation_border_width",
	"",
	esc_html__( "Border Top Width (px)", 'hudson' ),
	esc_html__( "Choose border top width for navigation", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$portfolio_hide_pagination_container->addChild(
	"portfolio_navigation_border_width",
	$portfolio_navigation_border_width
);

$portfolio_box = new HudsonEdgeField(
	"yesno",
	"portfolio_box",
	"yes",
	esc_html__( "Enable Box Holder", 'hudson' ),
	esc_html__( "Enabling this option will place box holder on project. This option works only if Portfolio style is Big Images, Big Slider or Gallery", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "#edgtf_portfolio_without_box_container",
		"dependence_show_on_yes" => "#edgtf_portfolio_box_container"
	)
);
$panel2->addChild(
	"portfolio_box",
	$portfolio_box
);

$portfolio_box_container = new HudsonEdgeContainer(
	"portfolio_box_container",
	"portfolio_box",
	"no"
);
$panel2->addChild(
	"portfolio_box_container",
	$portfolio_box_container
);

$portfolio_box_background_color = new HudsonEdgeField(
	"color",
	"portfolio_box_background_color",
	"",
	esc_html__( "Background Color", 'hudson' ),
	esc_html__( "Default color is #ffffff", 'hudson' )
);
$portfolio_box_container->addChild(
	"portfolio_box_background_color",
	$portfolio_box_background_color
);

$portfolio_box_lr_padding = new HudsonEdgeField(
	"text",
	"portfolio_box_lr_padding",
	"",
	esc_html__( "Padding(px)", 'hudson' ),
	esc_html__( "Format: 10px 5px 10px 8px (Default value is 46px 26px 45px 26px)", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$portfolio_box_container->addChild(
	"portfolio_box_lr_padding",
	$portfolio_box_lr_padding
);

$portfolio_without_box_container = new HudsonEdgeContainer(
	"portfolio_without_box_container",
	"portfolio_box",
	"yes"
);
$panel2->addChild(
	"portfolio_without_box_container",
	$portfolio_without_box_container
);

$portfolio_box_top_padding = new HudsonEdgeField(
	"text",
	"portfolio_box_top_padding",
	"",
	esc_html__( "Top Padding(px)", 'hudson' ),
	esc_html__( "Default value is 46", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$portfolio_without_box_container->addChild(
	"portfolio_box_top_padding",
	$portfolio_box_top_padding
);

$portfolio_columns_number = new HudsonEdgeField(
	"select",
	"portfolio_columns_number",
	"2",
	esc_html__( "Number of Columns", 'hudson' ),
	esc_html__( 'Enter the number of columns for Portfolio Gallery type', 'hudson' ),
	array(
		"2" => esc_html__( "2 columns", 'hudson' ),
		"3" => esc_html__( "3 columns", 'hudson' ),
		"4" => esc_html__( "4 columns", 'hudson' )
	)
);
$panel2->addChild(
	"portfolio_columns_number",
	$portfolio_columns_number
);

$portfolio_single_slug = new HudsonEdgeField(
	"text",
	"portfolio_single_slug",
	"",
	esc_html__( "Portfolio Single Slug", 'hudson' ),
	esc_html__( 'Enter if you wish to use a different Single Project slug (Note: After entering slug, navigate to Settings -> Permalinks and click "Save" in order for changes to take effect) ', 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$panel2->addChild(
	"portfolio_single_slug",
	$portfolio_single_slug
);

/*Navigation*/

$portfolio_navigation_title = new HudsonEdgeTitle(
	"portfolio_navigation_title",
	esc_html__( "Navigation", 'hudson' )
);
$panel2->addChild(
	"portfolio_navigation_title",
	$portfolio_navigation_title
);

$group16 = new HudsonEdgeGroup(
	esc_html__( "Icon Arrow Style", 'hudson' ),
	esc_html__( "Define navigation arrow style", 'hudson' )
);
$panel2->addChild(
	"group16",
	$group16
);

$row1 = new HudsonEdgeRow();
$group16->addChild(
	"row1",
	$row1
);

$portfolio_single_navigation_arrow_color = new HudsonEdgeField(
	"colorsimple",
	"portfolio_single_navigation_arrow_color",
	"",
	esc_html__( "Arrow Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"portfolio_single_navigation_arrow_color",
	$portfolio_single_navigation_arrow_color
);

$portfolio_single_navigation_arrow_hover_color = new HudsonEdgeField(
	"colorsimple",
	"portfolio_single_navigation_arrow_hover_color",
	"",
	esc_html__( "Arrow Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"portfolio_single_navigation_arrow_hover_color",
	$portfolio_single_navigation_arrow_hover_color
);

$group22 = new HudsonEdgeGroup(
	esc_html__( "Back To Button style", 'hudson' ),
	esc_html__( "Choose color and hover color", 'hudson' )
);
$panel2->addChild(
	"group22",
	$group22
);

$row1 = new HudsonEdgeRow();
$group22->addChild(
	"row1",
	$row1
);

$portfolio_back_to_button_icon_color = new HudsonEdgeField(
	"colorsimple",
	"portfolio_back_to_button_icon_color",
	"",
	esc_html__( "Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"portfolio_back_to_button_icon_color",
	$portfolio_back_to_button_icon_color
);

$portfolio_back_to_button_icon_hover_color = new HudsonEdgeField(
	"colorsimple",
	"portfolio_back_to_button_icon_hover_color",
	"",
	esc_html__( "Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"portfolio_back_to_button_icon_hover_color",
	$portfolio_back_to_button_icon_hover_color
);